<?php
/*
*@author arnee
*google-sitemap-TearSnow
*/
#region PHP5 compat functions
if (!function_exists('file_get_contents')) {
	/**
	 * Replace file_get_contents()
	 *
	 * @category    PHP
	 * @package     PHP_Compat
	 * @link        http://php.net/function.file_get_contents
	 * @author      Aidan Lister <aidan - php - net>
	 * @version     $Revision: 1.21 $
	 * @internal    resource_context is not supported
	 * @since       PHP 5
	 */
	function file_get_contents($filename, $incpath = false, $resource_context = null) {
		if (false === $fh = fopen($filename, 'rb', $incpath)) {
			user_error('file_get_contents() failed to open stream: No such file or directory', E_USER_WARNING);
			return false;
		}
		
		clearstatcache();
		if ($fsize = @filesize($filename)) {
			$data = fread($fh, $fsize);
		} else {
			$data = '';
			while (!feof($fh)) {
				$data .= fread($fh, 8192);
			}
		}
		
		fclose($fh);
		return $data;
	}
}


if(!function_exists('file_put_contents')) {
	
	if (!defined('FILE_USE_INCLUDE_PATH')) {
		define('FILE_USE_INCLUDE_PATH', 1);
	}
	
	if (!defined('LOCK_EX')) {
		define('LOCK_EX', 2);
	}
	
	if (!defined('FILE_APPEND')) {
		define('FILE_APPEND', 8);
	}
	
	
	/**
	 * Replace file_put_contents()
	 *
	 * @category    PHP
	 * @package     PHP_Compat
	 * @link        http://php.net/function.file_put_contents
	 * @author      Aidan Lister <aidan - php - net>
	 * @version     $Revision: 1.25 $
	 * @internal    resource_context is not supported
	 * @since       PHP 5
	 * @require     PHP 4.0.0 (user_error)
	 */
	function file_put_contents($filename, $content, $flags = null, $resource_context = null) {
		// If $content is an array, convert it to a string
		if (is_array($content)) {
			$content = implode('', $content);
		}
		
		// If we don't have a string, throw an error
		if (!is_scalar($content)) {
			user_error('file_put_contents() The 2nd parameter should be either a string or an array',E_USER_WARNING);
			return false;
		}
		
		// Get the length of data to write
		$length = strlen($content);
		
		// Check what mode we are using
		$mode = ($flags & FILE_APPEND)?'a':'wb';
		
		// Check if we're using the include path
		$use_inc_path = ($flags & FILE_USE_INCLUDE_PATH)?true:false;
		
		// Open the file for writing
		if (($fh = @fopen($filename, $mode, $use_inc_path)) === false) {
			user_error('file_put_contents() failed to open stream: Permission denied',E_USER_WARNING);
			return false;
		}
		
		// Attempt to get an exclusive lock
		$use_lock = ($flags & LOCK_EX) ? true : false ;
		if ($use_lock === true) {
			if (!flock($fh, LOCK_EX)) {
				return false;
			}
		}
		
		// Write to the file
		$bytes = 0;
		if (($bytes = @fwrite($fh, $content)) === false) {
			$errormsg = sprintf('file_put_contents() Failed to write %d bytes to %s',$length,$filename);
			user_error($errormsg, E_USER_WARNING);
			return false;
		}
		
		// Close the handle
		@fclose($fh);
		
		// Check all the data was written
		if ($bytes != $length) {
			$errormsg = sprintf('file_put_contents() Only %d of %d bytes written, possibly out of free disk space.',$bytes,$length);
			user_error($errormsg, E_USER_WARNING);
			return false;
		}
		
		// Return length
		return $bytes;
	}
	
}
#endregion


/*
*@author arnee
*google-sitemap-TearSnow
*/
if (!function_exists('Svlik_GetHomePath')) {
function Svlik_GetHomePath() {
	
	$res="";
	//Check if we are in the admin area -> get_home_path() is avaiable
	if(function_exists("get_home_path")) {
		$res = get_home_path();
	} else {
		//get_home_path() is not available, but we can't include the admin
		//libraries because many plugins check for the "check_admin_referer"
		//function to detect if you are on an admin page. So we have to copy
		//the get_home_path function in our own...
		$home = get_option( 'home' );
		if ( $home != '' && $home != get_option( 'siteurl' ) ) {
			$home_path = parse_url( $home );
			$home_path = $home_path['path'];
			$root = str_replace( $_SERVER["PHP_SELF"], '', $_SERVER["SCRIPT_FILENAME"] );
			$home_path = trailingslashit( $root.$home_path );
		} else {
			$home_path = ABSPATH;
		}

		$res = $home_path;
	}
	return $res;
}
}



/*
*@author arnee
*/
function Svlik_EscapeXML($string) {
	return str_replace ( array ( '&', '"', "'", '<', '>'), array ( '&amp;' , '&quot;', '&apos;' , '&lt;' , '&gt;'), $string);
}


/**
 * Checks if a file is writable and tries to make it if not.
 *
 * @since 3.05b
 * @access private
 * @author  VJTD3 <http://www.VJTD3.com>
 * @return bool true if writable
 */
if (!function_exists('IsFileWritable')) {
function IsFileWritable($filename) {
	clearstatcache();
	//can we write?
	if(!is_writable($filename)) {
		//no we can't.
		if(!@chmod($filename, 0666)) {
			$pathtofilename = dirname($filename);
			//Lets check if parent directory is writable.
			if(!is_writable($pathtofilename)) {
				//it's not writeable too.
				if(!@chmod($pathtoffilename, 0666)) {
					//darn couldn't fix up parrent directory this hosting is foobar.
					//Lets error because of the permissions problems.
					return false;
				}
			}
		}
	}
	//we can write, return 1/true/happy dance.
	return true;
}
}


/*
*
*Un-quotes quoted string\
*/
if (!function_exists('stripslashes_deep')) {
	function stripslashes_deep($value)
	{
		$value = is_array($value) ?
					array_map('stripslashes_deep', $value) :
					stripslashes($value);

		return $value;
	}
}


/**
 * Returns the path to the directory where the plugin file is located
 * @since 3.0b5
 * @access private
 * @author Arne Brachhold
 * @return string The path to the plugin directory
 */
if (!function_exists('GetPluginPath')) {
function GetPluginPath() {
	$path = dirname(__FILE__);
	return trailingslashit(str_replace("\\","/",$path));
}
}


/**
 * Returns the URL to the directory where the plugin file is located
 * @since 3.0b5
 * @access private
 * @author Arne Brachhold
 * @return string The URL to the plugin directory
 */
if (!function_exists('GetPluginUrl')) {
function GetPluginUrl() {
	
	//Try to use WP API if possible, introduced in WP 2.6
	if (function_exists('plugins_url')) return trailingslashit(plugins_url(basename(dirname(__FILE__))));
	
	//Try to find manually... can't work if wp-content was renamed or is redirected
	$path = dirname(__FILE__);
	$path = str_replace("\\","/",$path);
	$path = trailingslashit(get_bloginfo('wpurl')) . trailingslashit(substr($path,strpos($path,"wp-content/")));
	return $path;
}
}


/**
*load_plugin_textdomain('sitemap');
*@author Arne Brachhold
*/

function Svlik_sidebar() {?>
<style type="text/css">
a.Svlik_button {
	padding:4px;
	display:block;
	padding-left:25px;
	background-repeat:no-repeat;
	background-position:5px 50%;
	text-decoration:none;
	border:none;
}
</style>
<?php
}

function fanly_xml_file_exist() {
	$Svlik_blog_url = home_url();
	$filePath = Svlik_GetHomePath();
	$filename = $filePath.'sitemap.xml';
	$filemipname = $filePath.'mip_sitemap.xml';
	echo '<div class="tool-box">';
	echo '<h3 class="title">XML 文件状态</h3>';
    if(file_exists($filemipname)){
		$fanly_sitemap = get_fanly_sitemap();
		$mipurl =str_replace(strtok(str_replace("//","",strstr($Svlik_blog_url,"//")), '/'),$fanly_sitemap['MIP_XML_Sitemap'],$Svlik_blog_url);
		date_default_timezone_set ('Asia/Shanghai');
		$filemtime=date("Y-m-d H:i:s",filemtime("$filemipname")); 
		echo '<p>检查 MIP XML 文件：<a href="'.$mipurl.'/mip_sitemap.xml'.'" target="_blank">'.$mipurl.'/mip_sitemap.xml'.'</a>（'.$filemtime.'）</p>';
	}
	if(file_exists($filename)){
		date_default_timezone_set ('Asia/Shanghai');
		$filemtime=date("Y-m-d H:i:s",filemtime("$filename")); 
		echo '<p>检查 XML 文件：<a href="'.$Svlik_blog_url.'/sitemap.xml'.'" target="_blank">'.$Svlik_blog_url.'/sitemap.xml'.'</a>（'.$filemtime.'）</p>';
		echo '<p>添加Sitemap到robots.txt：</p>';
		echo '<pre><b>Sitemap: '.$Svlik_blog_url.'/sitemap.xml</b></pre>';
	}
	$sitemap_html = Svlik_GetHomePath().'sitemap.html'; if(file_exists($sitemap_html)) { echo '<p>检查 Html 静态页面： '; echo '<a href="'.$Svlik_blog_url.'/sitemap.html'.'" target="_blank">'.$Svlik_blog_url.'/sitemap.html'.'</a></p>'; echo '<p>在首页添加此html的链接，方便搜索引擎抓取。'; print '</p>'; }
	
	if(!file_exists($filemipname) && !file_exists($filename) && !file_exists(Svlik_GetHomePath().'sitemap.html')){
		echo '<p>你还未设置或者生成任何地图文件！</p>';
	}
	echo '</div>';
}
function fanly_xml_annotate() {
	$blogtime = current_time('mysql'); 
	$xml_author_annotate = '<!-- generated-on="'.$blogtime.'" By Svlik(www.svlik.com) -->';
    return $xml_author_annotate;
}

function Svlik_GetTimestampFromMySql($mysqlDateTime) {
	list($date, $hours) = explode(' ', $mysqlDateTime);
	list($year,$month,$day) = explode('-',$date);
	list($hour,$min,$sec) = explode(':',$hours);
	return mktime(intval($hour), intval($min), intval($sec), intval($month), intval($day), intval($year));
}
?>