<?php
/*
Plugin Name: Svlik SiteMap
Plugin URI: https://www.svlik.com/
Description: WordPress XML地图插件，MIP版。
Author: Svlik
Version: 1.1
Author URI: https://www.svlik.com/
*/

//define the field name of database
define('SITEMAP_OPTION','Svlik_SiteMap');

//load
require_once("Svlik-SiteMap-Function.php");

//add a Menu,like "Sitemap"
add_action('admin_menu','Svlik_SiteMap');
function Svlik_SiteMap() {
   //Add a page to the options section of the website
   if (current_user_can('manage_options')) 				
		add_submenu_page('options-general.php','Svlik SiteMap', 'Svlik SiteMap', 'manage_options', 'Svlik_SiteMap', 'fanly_sitemap_menu', '');
}
//add plugin link
add_filter( 'plugin_action_links', 'Svlik_SiteMap_Add_Link', 10, 5 );
function Svlik_SiteMap_Add_Link( $actions, $plugin_file ) {
	static $plugin;
	if (!isset($plugin))
		$plugin = plugin_basename(__FILE__);
	if ($plugin == $plugin_file) {
			$settings = array('settings' => '<a href="'.('options-general.php?page=Svlik_SiteMap').'">' . __('Settings') . '</a>');
			$site_link = array('support' => '<a href="http://zhangzifan.com" target="_blank">Svlik</a>');
			$actions = array_merge($settings, $actions);
			$actions = array_merge($site_link, $actions);
	}
	return $actions;
}
//remove plugin 
add_filter( 'plugin_action_links', 'Svlik_SiteMap_remove_plugin_link', 10, 4 );
function Svlik_SiteMap_remove_plugin_link( $actions, $plugin_file, $plugin_data, $context ){
	if(isset($actions['edit'])){
		switch($plugin_file){
			case 'Svlik-SiteMap/Svlik-SiteMap.php':unset( $actions['edit'] );
			break;
		}
	}
	return $actions;
}

//custom message
function sitemap_topbarmessage($msg) {
	 echo '<div class="updated fade" id="message"><p>' . $msg . '</p></div>';
}
//get options
function get_fanly_sitemap(){
	$fanly_sitemap = array();
	$get_fanly_sitemap = get_option(SITEMAP_OPTION);
	if( $get_fanly_sitemap ){
		list( $fanly_sitemap['MIP_XML_Sitemap'],$fanly_sitemap['MIP_Site'],$fanly_sitemap['XML_Sitemap'], $fanly_sitemap['Html_Sitemap'], $fanly_sitemap['sitemap_when_post'], $fanly_sitemap['post_limit_1000'], $fanly_sitemap['post'], $fanly_sitemap['page'], $fanly_sitemap['cat'], $fanly_sitemap['tag'] ) = explode("|",$get_fanly_sitemap);
	}else{
		if( !$fanly_sitemap['XML_Sitemap'] ){ $fanly_sitemap['XML_Sitemap'] = 1; }
		if( !$fanly_sitemap['sitemap_when_post'] ){ $fanly_sitemap['sitemap_when_post'] = 1; }
		if( !$fanly_sitemap['post_limit_1000'] ){ $fanly_sitemap['post_limit_1000'] = 1; }
	}
	return $fanly_sitemap;
}

//sitemap page
function fanly_sitemap_form() {
	$fanly_sitemap = get_fanly_sitemap();
	?>
    <div class="wrap">
		<div class="postbox-container" style="width:75%;">
		<div class="metabox-holder">
		<div class="meta-box-sortables">	
						
		<div class="tool-box">
			<a name="sitemap_options"></a><form name="sitemap_options" method="post" action="">
			<input type="hidden" name="action" value="build_options" />
			<table>
				<tr><td><h3>基本配置</h3></td></tr>
				<tr><td>生成MIP XML</td><td>
<?php
if(class_exists('SvlikDomainTheme')) {
	$SvlikDomainTheme = unserialize(get_option("SvlikDomainTheme_options"));
	echo '<select name="MIP_XML_Sitemap" id="Site">';
	foreach($SvlikDomainTheme as $domain){
		if($fanly_sitemap['MIP_XML_Sitemap'] == $domain['url']){$sl = ' selected';}else{$sl='';}
		echo '<option value="'.$domain['url'].'"'.$sl.'>'.$domain['url'].'</option>';
	}
	if($fanly_sitemap['MIP_XML_Sitemap'] == $fanly_sitemap['MIP_Site']){$custom = ' selected';}else{$custom='';}
	echo '<option value="custom"'.$custom.'>自定义MIP Site</option>';
	if($fanly_sitemap['MIP_XML_Sitemap'] == '0'){$sl = ' selected';}else{$sl='';}
	echo '<option value="0"'.$sl.'>不生成</option>';
	echo '</select>';
}else{
	echo '<select name="MIP_XML_Sitemap" id="Site">';
	if($fanly_sitemap['MIP_XML_Sitemap'] == '0'){$sl = ' selected';}else{$sl='';}
	echo '<option value="0"'.$sl.'>不生成</option>';
	if($fanly_sitemap['MIP_XML_Sitemap'] == $fanly_sitemap['MIP_Site']){$custom = ' selected';}else{$custom='';}
	echo '<option value="custom"'.$custom.'>自定义MIP Site</option>';
	echo '<option value="0">更多域名需要SvlikDomainTheme插件支持</option>';
	echo '</select>';
}
?>
                </td></tr>
				<tr id="CustomSite"><td>自定义 MIP Site</td><td><input type="text" name="MIP_Site" value="<?php echo $fanly_sitemap['MIP_Site']?>" /></td></tr>
				<tr><td>生成 XML 地图</td><td><input type="checkbox" name="XML_Sitemap" value="1" <?php if( $fanly_sitemap['XML_Sitemap'] ) { echo 'checked="checked"'; } ?> /></td></tr>
				<tr><td>生成 Html 地图</td><td><input type="checkbox" name="Html_Sitemap" value="1" <?php if( $fanly_sitemap['Html_Sitemap'] ) { echo 'checked="checked"'; } ?> /></td><td><a title="静态HTML网站地图">[?]</a><td></tr>
				<tr><td>发布文章自动更新</td><td><input type="checkbox" name="sitemap_when_post" value="1" <?php if( $fanly_sitemap['sitemap_when_post'] ) { echo 'checked="checked"'; } ?> /></td></tr>
				<tr><td>只生成最近的文章(1000以内)</td><td><input type="checkbox" name="post_limit_1000" value="1" <?php if( $fanly_sitemap['post_limit_1000'] ) { echo 'checked="checked"'; } ?> /></td><td><a title="只需将最近一个更新周期内新增的和变化了的文章包含在XML页面上，过多的数量只会增加服务器的负担。">[?]</a><td></tr>
				<tr><td>包含链接</td><td>
                	<label style="padding-right:10px;"><input type="checkbox" name="post" value="1" checked readonly />文章</label>
                	<label style="padding-right:10px;"><input type="checkbox" name="page" value="1" <?php if( $fanly_sitemap['page'] ) { echo 'checked="checked"'; } ?> />页面</label>
                	<label style="padding-right:10px;"><input type="checkbox" name="cat" value="1" <?php if( $fanly_sitemap['cat'] ) { echo 'checked="checked"'; } ?> />分类</label>
                	<label style="padding-right:10px;"><input type="checkbox" name="tag" value="1" <?php if( $fanly_sitemap['tag'] ) { echo 'checked="checked"'; } ?> />标签</label>
                </td></tr>
			</table>
			<p class="submit"><input type="submit" class="button-primary" /></p>
			</form>
<script type="text/javascript">
	jQuery(function(){
<?php if($fanly_sitemap['MIP_XML_Sitemap'] != $fanly_sitemap['MIP_Site']){?>
		jQuery("#CustomSite").hide();
<?php }?>
		jQuery("select#Site").change(function(){
			var selected = jQuery("select#Site").val();
			if(selected == "custom"){
				jQuery("#CustomSite").show();
			}else{
				jQuery("#CustomSite").hide();
			}
		});
	});
</script> 
		</div>


		<div class="tool-box">
		<h3 class="title">生成XML文件</h3>
				<form name="sitemap_build" method="post" action="">
				<input type="hidden" name="action" value="build_xml" />
				<p class="submit"><input type="submit" class="button-primary" value="更新地图" /></p>
				</form>
		</div>


			<?php
			//show the XML file if exist
			fanly_xml_file_exist();
			?>
		</div>
		</div>
		</div>
	</div>
	<?php
}


//sitemap page
function fanly_sitemap_menu(){
      //Perform any action
		if(isset($_POST["action"])) {
			if ($_POST["action"]=='build_options') {update_fanly_sitemap(); }
		    if ($_POST["action"]=='build_xml') { fanly_sitemap_build();}
		}
		
		//Definition
		echo '<h2>Svlik SiteMap</h2>';

		//Introduction 
		echo '<p>一个支持WordPress生成XML地图、HTML地图以及支持生成MIP XML地图文件。</p>';
		
		//show the option Form 
		fanly_sitemap_form();

		//Show the plugins Author
		Svlik_sidebar();
	
}

//update the options
function update_fanly_sitemap() {
	if ($_POST['action']=='build_options'){
		$MIP_XML_Sitemap = $_POST['MIP_XML_Sitemap'];
		if($MIP_XML_Sitemap == 'custom'){
			$MIPSite = $_POST['MIP_Site'];
			if(strstr($MIPSite,"//")){ 
				$MIPSite = strtok(str_replace("//","",strstr($MIPSite,"//")), '/');
			}else{$MIPSite = strtok($MIPSite, '/');}
			$MIP_XML_Sitemap = $MIPSite;
			$MIP_Site = $MIPSite;
		}else{$MIP_XML_Sitemap = $_POST['MIP_XML_Sitemap'];}
		if(!$MIP_XML_Sitemap){ $MIP_XML_Sitemap = 0; }

		if(!$MIP_Site){ $MIP_Site = ''; }
		
		$XML_Sitemap = $_POST['XML_Sitemap'];
		if(!$XML_Sitemap){ $XML_Sitemap = 0; }
		
		$Html_Sitemap = $_POST['Html_Sitemap'];
		if(!$Html_Sitemap){ $Html_Sitemap = 0; }
		
		$sitemap_when_post = $_POST['sitemap_when_post'];
		if(!$sitemap_when_post){ $sitemap_when_post = 0; }
		
		$post_limit_1000 = $_POST['post_limit_1000'];
		if(!$post_limit_1000){ $post_limit_1000 = 0; }
		
		$fanly_post = $_POST['post'];
		if(!$fanly_post){ $fanly_post = 0; }
		$fanly_page = $_POST['page'];
		if(!$fanly_page){ $fanly_post = 0; }
		$fanly_cat = $_POST['cat'];
		if(!$fanly_cat){ $fanly_cat = 0; }
		$fanly_tag = $_POST['tag'];
		if(!$fanly_tag){ $fanly_tag = 0; }
		
		$sitemap_options = implode('|',array($MIP_XML_Sitemap,$MIP_Site,$XML_Sitemap, $Html_Sitemap, $sitemap_when_post, $post_limit_1000, $fanly_post, $fanly_page, $fanly_cat, $fanly_tag));
		update_option(SITEMAP_OPTION,$sitemap_options); 
        sitemap_topbarmessage('更新配置成功');
		fanly_sitemap_build();
	}
}


//build the XML file, sitemap.xml
add_action('do_sitemap_by_post','fanly_sitemap_build',2,0); 
function fanly_sitemap_build() {
    global $wpdb, $post;
	$fanly_sitemap = get_fanly_sitemap();
	if($fanly_sitemap['post_limit_1000']){ $Svlik_limit = '1000'; } else { $Svlik_limit = '10000'; }

    ## $Svlik_contents , $Svlik_limit = '1000'
	$sql_mini = "select ID,post_modified_gmt,post_date_gmt,post_type FROM $wpdb->posts
	        WHERE post_password = ''
			AND (post_type != 'revision' AND post_type != 'attachment' AND post_type != 'nav_menu_item')
			AND post_status = 'publish'
			ORDER BY post_modified_gmt DESC
			LIMIT 0,$Svlik_limit
	       ";
	$recentpost = $wpdb->get_results($sql_mini);
	if($recentpost){
		foreach ($recentpost as $post){
			if( $post->post_type == 'page' ){
				if(!$fanly_sitemap['page']){ continue; } //跳过
				$loc = get_page_link($post->ID);
				$loc = Svlik_EscapeXML($loc);
				if(!$loc){ continue; }
				if($post->post_modified_gmt == '0000-00-00 00:00:00'){ $post_date_gmt = $post->post_date_gmt; } else { $post_date_gmt = $post->post_modified_gmt; } 
				$lastmod = date("Y-m-d\TH:i:s+00:00",Svlik_GetTimestampFromMySql($post_date_gmt));
				$changefreq = 'weekly';
				$priority = '0.3';
				$xml_content_page .= "<url>";
				$xml_content_page .= "<loc>$loc</loc>";
				$xml_content_page .= "<lastmod>$lastmod</lastmod>";
				$xml_content_page .= "<changefreq>$changefreq</changefreq>";
				$xml_content_page .= "<priority>$priority</priority>";
				$xml_content_page .= "</url>";
			}
		}
		
		$args = array(
			'showposts' => $Svlik_limit,//显示文章数量
			'ignore_sticky_posts' => 1, //忽略sticky_posts，即不置顶（不将置顶文章提至最前），但是输出置顶文章
		);
		$query = new WP_Query( $args );
		while ($query->have_posts()) : $query->the_post();
			$loc = get_permalink();
			$loc = Svlik_EscapeXML($loc);
			if(!$loc){ continue; }
			$lastmod = get_the_modified_time('Y-m-d\TH:i:s+00:00');
			$changefreq = 'monthly';
			$priority = '0.6';
			$xml_content_post .= "<url>";
			$xml_content_post .= "<loc>$loc</loc>";
			$xml_content_post .= "<lastmod>$lastmod</lastmod>";
			$xml_content_post .= "<changefreq>$changefreq</changefreq>";
			$xml_content_post .= "<priority>$priority</priority>";
			$xml_content_post .= "</url>";
		endwhile;

		## get_category_link
		$category_ids = get_all_category_ids();
		foreach($category_ids as $cat_id) {
			if(!$fanly_sitemap['cat']){ continue; } //跳过
			$loc = get_category_link($cat_id);
			$loc = Svlik_EscapeXML($loc);
			if(!$loc){ continue; }
			$lastmod = date("Y-m-d\TH:i:s+00:00",current_time('timestamp', '1'));
			$changefreq = 'Weekly';
			$priority = '0.3';
			$xml_content_cat .= "<url>";
			$xml_content_cat .= "<loc>$loc</loc>";
			$xml_content_cat .= "<lastmod>$lastmod</lastmod>";
			$xml_content_cat .= "<changefreq>$changefreq</changefreq>";
			$xml_content_cat .= "<priority>$priority</priority>";
			$xml_content_cat .= "</url>";
		}
		## get_tags
		$all_the_tags = get_tags();
		if($all_the_tags){
			foreach($all_the_tags as $this_tag) {
				if(!$fanly_sitemap['tag']){ continue; } //跳过
				$tag_id = $this_tag->term_id;
				$loc = get_tag_link($tag_id);
				$loc = Svlik_EscapeXML($loc);
				if(!$loc){ continue; }
				$lastmod = date("Y-m-d\TH:i:s+00:00",current_time('timestamp', '1'));
				$changefreq = 'Weekly';
				$priority = '0.3';
				$xml_content_tag .= "<url>";
				$xml_content_tag .= "<loc>$loc</loc>";
				$xml_content_tag .= "<lastmod>$lastmod</lastmod>";
				$xml_content_tag .= "<changefreq>$changefreq</changefreq>";
				$xml_content_tag .= "<priority>$priority</priority>";
				$xml_content_tag .= "</url>";
			}
		}

		##
		$xml_contents = $xml_content_post.$xml_content_page.$xml_content_cat.$xml_content_tag;
	}


	## XML
	if($fanly_sitemap['XML_Sitemap']){
		fanly_sitemap_build_xml($xml_contents);
	}else{//删除
		Svlik_SiteMap_DEL('sitemap.xml');
	}
	## MIP XML
	if($fanly_sitemap['MIP_XML_Sitemap']){
		build_mip_sitemap_xml($xml_contents);
	}else{//删除
		Svlik_SiteMap_DEL('mip_sitemap.xml');
	}
	## Html
	if($fanly_sitemap['Html_Sitemap']){
		fanly_sitemap_build_html();
	}else{//删除
		Svlik_SiteMap_DEL('sitemap.html');
	}

	if(function_exists('wp_clear_scheduled_hook')) { wp_clear_scheduled_hook('do_sitemap_by_post'); }
    //sitemap_is_auto_daily(); 
}

function Svlik_SiteMap_DEL($file){
	$file = Svlik_GetHomePath().$file;//基于站点根目录
	if(is_file($file)){
		if(unlink($file)){
			sitemap_topbarmessage("文件{$file}删除完毕!");
		}else{
			//echo "文件{$file}删除失败...!尝试修改文件权限删除...";
			if(chmod($file,0777)){
				unlink($file);
				sitemap_topbarmessage("文件{$file}权限修改后删除完毕...");
			}else{
				sitemap_topbarmessage("文件{$file}无法自动删除，请手动通过FTP删除！");
			}
		}
	}
}
//MIP XML
function build_mip_sitemap_xml($xml_contents){
	$Svlik_blog_url = home_url();
	$blogtime = current_time('timestamp', '1');
	$Svlik_blog_time = date("Y-m-d\TH:i:s+00:00",$blogtime);

	$xml_begin = '<?xml version="1.0" encoding="UTF-8"?>'.fanly_xml_annotate().'<urlset xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.sitemaps.org/schemas/sitemap/0.9 http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd" xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">';
	$xml_home = "<url><loc>$Svlik_blog_url</loc><lastmod>$Svlik_blog_time</lastmod><changefreq>daily</changefreq><priority>1.0</priority></url>";
	$xml_end = '</urlset>';
	if($xml_contents){
		$fanly_sitemap = get_fanly_sitemap();
		$xml = $xml_begin.$xml_home.$xml_contents.$xml_end;
		$xml = str_replace(str_replace("//","",strstr(home_url(),"//")),$fanly_sitemap['MIP_XML_Sitemap'],$xml);

		//save XML file as sitemap.xml
		$Svlik_GetHomePath = Svlik_GetHomePath();
		$filename = $Svlik_GetHomePath.'mip_sitemap.xml';
		if( IsFileWritable($Svlik_GetHomePath) || IsFileWritable($filename) ){ 
			file_put_contents("$filename","$xml"); 
			@chmod($filename, 0777);
			//Messages
			sitemap_topbarmessage('更新 MIP XML 文件成功!');
		}else{ 
			//Messages
			sitemap_topbarmessage('文件或目录不可写，请修改根目录权限改为777。');
		}
	}
}

//XML
function fanly_sitemap_build_xml($xml_contents){
	$Svlik_blog_url = home_url();
	$blogtime = current_time('timestamp', '1');
	$Svlik_blog_time = date("Y-m-d\TH:i:s+00:00",$blogtime);

	$xml_begin = '<?xml version="1.0" encoding="UTF-8"?>'.fanly_xml_annotate().'<urlset xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.sitemaps.org/schemas/sitemap/0.9 http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd" xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">';
	$xml_home = "<url><loc>$Svlik_blog_url</loc><lastmod>$Svlik_blog_time</lastmod><changefreq>daily</changefreq><priority>1.0</priority></url>";
	$xml_end = '</urlset>';
	if($xml_contents){
		$xml = $xml_begin.$xml_home.$xml_contents.$xml_end;

		//save XML file as sitemap.xml
		$Svlik_GetHomePath = Svlik_GetHomePath();
		$filename = $Svlik_GetHomePath.'sitemap.xml';
		if( IsFileWritable($Svlik_GetHomePath) || IsFileWritable($filename) ){ 
			file_put_contents("$filename","$xml"); 
			@chmod($filename, 0777);
			//Messages
			sitemap_topbarmessage('更新 XML 文件成功!');
		}else{ 
			//Messages
			sitemap_topbarmessage('文件或目录不可写，请修改根目录权限改为777。');
		}
	}
}
function fanly_sitemap_build_html(){
	global $wpdb;
	$fanly_sitemap = get_fanly_sitemap();
	if($fanly_sitemap['post_limit_1000']){ $Svlik_limit = '1000'; } else { $Svlik_limit = '10000'; }

    ##文章
	$html_contents = $html_category_contents = $html_page_contents = $html_tag_contents = '';
	$args = array(
		'showposts' => $Svlik_limit,//显示文章数量
		'ignore_sticky_posts' => 1, //忽略sticky_posts，即不置顶（不将置顶文章提至最前），但是输出置顶文章
	);
	$query = new WP_Query( $args );
	while ($query->have_posts()) : $query->the_post();
	$html_contents .= '<li><a href="'.get_permalink().'" title="'.get_the_title().'" target="_blank">'.get_the_title().'</a></li>';
	endwhile;

	if($fanly_sitemap['cat'])
		$html_category_contents	= '<h2>分类</h2><ul>'.wp_list_categories('echo=0&title_li=').'</ul>';
	if($fanly_sitemap['page'])
		$html_page_contents		= '<h2>页面</h2><ul>'.wp_list_pages('echo=0&title_li=').'</ul>';
	if($fanly_sitemap['tag'])
		$html_tag_contents		= '<h2>标签</h2>'.wp_tag_cloud('echo=0&number=245');
	
	$Svlik_contents = $html_page_contents.$html_category_contents.$html_tag_contents;

	$blog_title = 'SiteMap';
	$blog_name = get_bloginfo('name'); 
	$blog_keywords = 'SiteMap,网站地图'.$blog_name;
	$Svlik_author = $blog_name;
	$Svlik_copyright = 'www.Svlik.com';
	$blog_home = get_bloginfo('url');
	$sitemap_url = get_bloginfo('url').'/sitemap.html';
	$recentpost = '最新文章';
	$footnote = '首页';
	$updated_time = current_time('mysql');

	if($html_contents) { 
		$path_html  = GetPluginPath().'sitemap.html';
		$html = file_get_contents("$path_html");
		
		$html = str_replace("%blog_title%",$blog_title,$html);
		$html = str_replace("%blog_name%",$blog_name,$html);
		$html = str_replace("%blog_home%",$blog_home,$html);
		$html = str_replace("%blog_keywords%",$blog_keywords,$html);
		$html = str_replace("%Svlik_author%",$Svlik_author,$html);
		$html = str_replace("%Svlik_copyright%",$Svlik_copyright,$html);
		$html = str_replace("%sitemap_url%",$sitemap_url,$html);
		$html = str_replace("%footnote%",$footnote,$html);
		$html = str_replace("%RecentPost%",$recentpost,$html);
		$html = str_replace("%updated_time%",$updated_time,$html);
		$html = str_replace("%contents%",$html_contents,$html);
		$html = str_replace("%Svlik_contents%",$Svlik_contents,$html);
		$Svlik_GetHomePath = Svlik_GetHomePath();
		$filename_html = $Svlik_GetHomePath.'sitemap.html';
		if( IsFileWritable($Svlik_GetHomePath) || IsFileWritable($filename_html) ){ 
			file_put_contents("$filename_html","$html");
			@chmod($filename_html, 0777);
			//Messages
			sitemap_topbarmessage('更新HTML地图成功!');
		}
	}
}
	

## Auto
add_action('init','sitemap_is_auto_daily',1001,0);
function sitemap_is_auto_daily() {
	$Svlik_updatePeri = $Svlik_updatePeri*60*60*24;
	wp_schedule_single_event(time()+$Svlik_updatePeri, 'do_this_auto_daily'); 
	add_action('do_this_auto_daily','fanly_sitemap_build',2,0); 
}

add_action('publish_post', 'sitemap_by_post');
function sitemap_by_post($post_ID) {
	$get_fanly_sitemap = get_fanly_sitemap();
	if($get_fanly_sitemap['sitemap_when_post'] == '1'){
		   wp_clear_scheduled_hook('do_sitemap_by_post');
		   wp_schedule_single_event(time()+30, 'do_sitemap_by_post'); 
	}
	return $post_ID;
}

?>