/*
 * Hello Minecraft! Launcher.
 * Copyright (C) 2013  huangyuhui <huanghongxun2008@126.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see {http://www.gnu.org/licenses/}.
 */
package org.jackhuang.hellominecraft.launcher.ui.modpack;

import java.util.Map;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.jackhuang.hellominecraft.util.C;
import org.jackhuang.hellominecraft.util.ui.wizard.spi.WizardController;

/**
 *
 * @author huangyuhui
 */
public class ModpackInitializationPanel extends javax.swing.JPanel {

    public static final String KEY_GAME_VERSION = "gameVersion";
    public static final String KEY_MODPACK_LOCATION = "modpackLocation";
    public static final String KEY_MODPACK_NAME = "modpackName";
    public static final String KEY_INCLUDING_LAUNCHER = "launcher";

    private final transient WizardController controller;
    private final Map wizardData;

    /**
     * Creates new form ModpackInitializationPanel
     */
    public ModpackInitializationPanel(WizardController controller, Map wizardData, Vector<String> versions, String selVersion) {
        initComponents();

        this.controller = controller;
        this.wizardData = wizardData;
        wizardData.put(KEY_GAME_VERSION, versions);
        wizardData.put("selVersion", selVersion);
        wizardData.put(KEY_INCLUDING_LAUNCHER, false);

        configureComboContents();
        checkProblem();
    }

    private void configureComboContents() {
        Vector<String> versions = (Vector<String>) wizardData.get(KEY_GAME_VERSION);
        cboGameVersion.setModel(new DefaultComboBoxModel<>(versions));
        wizardData.put(KEY_GAME_VERSION, wizardData.get("selVersion"));
    }

    /**
     * This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        lblModpackLocation = new javax.swing.JLabel();
        txtModpackLocation = new javax.swing.JTextField();
        cboModpackLocation = new javax.swing.JButton();
        lblGameVersion = new javax.swing.JLabel();
        cboGameVersion = new javax.swing.JComboBox<>();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        txtModpackName = new javax.swing.JTextField();
        chkIncludeLauncher = new javax.swing.JCheckBox();

        lblModpackLocation.setText(C.i18n("modpack.wizard.step.initialization.save")); // NOI18N

        txtModpackLocation.addCaretListener(new javax.swing.event.CaretListener() {
            public void caretUpdate(javax.swing.event.CaretEvent evt) {
                txtModpackLocationCaretUpdate(evt);
            }
        });

        cboModpackLocation.setText("...");
        cboModpackLocation.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cboModpackLocationActionPerformed(evt);
            }
        });

        lblGameVersion.setText(C.i18n("modpack.wizard.step.initialization.exported_version")); // NOI18N

        cboGameVersion.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                cboGameVersionItemStateChanged(evt);
            }
        });

        jLabel1.setText(C.i18n("modpack.wizard.step.initialization.warning")); // NOI18N

        jLabel2.setText(C.i18n("modpack.name")); // NOI18N

        txtModpackName.setToolTipText("");
        txtModpackName.addCaretListener(new javax.swing.event.CaretListener() {
            public void caretUpdate(javax.swing.event.CaretEvent evt) {
                txtModpackNameCaretUpdate(evt);
            }
        });

        chkIncludeLauncher.setText(C.i18n("modpack.wizard.step.initialization.include_launcher")); // NOI18N
        chkIncludeLauncher.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                chkIncludeLauncherItemStateChanged(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(txtModpackName)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(lblModpackLocation)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 353, Short.MAX_VALUE)
                        .addComponent(cboModpackLocation))
                    .addComponent(txtModpackLocation)
                    .addComponent(cboGameVersion, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(lblGameVersion)
                            .addComponent(jLabel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jLabel2)
                            .addComponent(chkIncludeLauncher))
                        .addGap(0, 0, Short.MAX_VALUE)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 19, Short.MAX_VALUE)
                .addComponent(jLabel2)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(txtModpackName, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lblModpackLocation)
                    .addComponent(cboModpackLocation))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(txtModpackLocation, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(lblGameVersion)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(cboGameVersion, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(chkIncludeLauncher)
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents

    private void cboModpackLocationActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cboModpackLocationActionPerformed
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(JFileChooser.FILES_ONLY);
        fc.setDialogTitle(C.i18n("modpack.wizard.step.initialization.save"));
        fc.setMultiSelectionEnabled(false);
        fc.setFileFilter(new FileNameExtensionFilter(C.i18n("modpack") + "(*.zip)", "zip"));
        fc.showSaveDialog(this);
        if (fc.getSelectedFile() != null) {
            String path = fc.getSelectedFile().getAbsolutePath();
            if (!path.endsWith(".zip"))
                path += ".zip";
            txtModpackLocation.setText(path);
        }
    }//GEN-LAST:event_cboModpackLocationActionPerformed

    private void txtModpackLocationCaretUpdate(javax.swing.event.CaretEvent evt) {//GEN-FIRST:event_txtModpackLocationCaretUpdate
        wizardData.put(KEY_MODPACK_LOCATION, txtModpackLocation.getText());

        checkProblem();
    }//GEN-LAST:event_txtModpackLocationCaretUpdate

    private void cboGameVersionItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_cboGameVersionItemStateChanged
        wizardData.put(KEY_GAME_VERSION, cboGameVersion.getSelectedItem());
    }//GEN-LAST:event_cboGameVersionItemStateChanged

    private void txtModpackNameCaretUpdate(javax.swing.event.CaretEvent evt) {//GEN-FIRST:event_txtModpackNameCaretUpdate
        wizardData.put(KEY_MODPACK_NAME, txtModpackName.getText());

        checkProblem();
    }//GEN-LAST:event_txtModpackNameCaretUpdate

    private void chkIncludeLauncherItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_chkIncludeLauncherItemStateChanged
        wizardData.put(KEY_INCLUDING_LAUNCHER, chkIncludeLauncher.isSelected());
    }//GEN-LAST:event_chkIncludeLauncherItemStateChanged

    static final Pattern PATTERN = Pattern.compile("[-a-zA-Z0-9_\\.\\(\\)\\[\\]\\{\\}\\<\\>\"\'\u4E00-\u9FA5]+$");

    void checkProblem() {
        controller.setProblem(null);
        if (txtModpackLocation.getText().trim().isEmpty())
            controller.setProblem(C.i18n("modpack.not_a_valid_location"));
        if (!PATTERN.matcher(txtModpackName.getText()).matches())
            controller.setProblem(C.i18n("modpack.not_a_valid_name"));
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox<String> cboGameVersion;
    private javax.swing.JButton cboModpackLocation;
    private javax.swing.JCheckBox chkIncludeLauncher;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel lblGameVersion;
    private javax.swing.JLabel lblModpackLocation;
    private javax.swing.JTextField txtModpackLocation;
    private javax.swing.JTextField txtModpackName;
    // End of variables declaration//GEN-END:variables
}
