package org.jackhuang.hellominecraft.launcher.util.download;



import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import org.jackhuang.hellominecraft.launcher.util.Json.Attribute;
import org.jackhuang.hellominecraft.launcher.util.Json.GsonDataAnalysis;
import sun.plugin2.message.Message;
import sun.rmi.runtime.Log;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.logging.Handler;

import static com.sun.org.apache.xalan.internal.xsltc.compiler.util.Type.Attribute;


class MainActivity {

    private static String name;
    private static String Versions;
    private static boolean update;
    private static String url;


    public static void main(String[] a) {
        sendRequest();
    }

    private static void sendRequest() {
        // 开启线程来发起网络请求
        new Thread(new Runnable() {
            @Override
            public void run() {
                HttpURLConnection connection = null;
                try {
                    URL url = new URL("https://shszcraft.com/dataJson.json");
                    connection = (HttpURLConnection) url.openConnection();
                    connection.setRequestMethod("GET");
                    connection.setConnectTimeout(8000);
                    connection.setReadTimeout(8000);
                    InputStream in = connection.getInputStream();
                    // 下面对获取到的输入流进行读取
                    BufferedReader reader = new BufferedReader(new
                            InputStreamReader(in));
                    String response = new String();
                    String line;
                    while ((line = reader.readLine()) != null) {
                        response += line;
                    }
                    parseJSONWithJSONObject(response);

                } catch (Exception e) {
                    e.printStackTrace();
                } finally {
                    if (connection != null) {
                        connection.disconnect();
                    }
                }
            }
        }).start();
    }

    private static void parseJSONWithJSONObject(String jsonData) {
        //使用 Gson 解析json数据
        Gson gson = new Gson();
        Attribute appList = new Attribute();
        appList = gson.fromJson(jsonData, Attribute.class);

        name = appList.getName();
        Versions = appList.getVersion();
        update = appList.getUpdate();
        url = appList.getUrl();

        System.out.print("Name：" + appList.getName());
    }
}

