/*
 * Decompiled with CFR 0.152.
 */
package yushijinhun.authlibagent.javaagent;

import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.Collection;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import yushijinhun.authlibagent.javaagent.AuthlibTransformer;
import yushijinhun.authlibagent.javaagent.SkinWhitelistDomainTransformUnit;
import yushijinhun.authlibagent.javaagent.Transformer;
import yushijinhun.authlibagent.javaagent.YggdrasilPublicKeyTransformUnit;

public class ExhaustiveTransformer
extends AuthlibTransformer {
    private String[] nonTransformablePackages = new String[]{"java.", "javax.", "com.sun.", "com.oracle.", "jdk.", "sun.", "org.apache.", "com.google.", "oracle.", "com.oracle.", "com.paulscode.", "io.netty.", "org.lwjgl.", "net.java.", "org.w3c.", "javassist"};

    public ExhaustiveTransformer(String apiYggdrasilAuthenticate, String apiYggdrasilRefresh, String apiYggdrasilValidate, String apiYgggdrasilInvalidate, String apiYggdarsilSignout, String apiFillGameProfile, String apiJoinServer, String apiHasJoinServer, String apiProfilesLookup, String[] skinWhitelist, byte[] yggdrasilPublickey, String apiUsername2Profile) {
        super(apiYggdrasilAuthenticate, apiYggdrasilRefresh, apiYggdrasilValidate, apiYgggdrasilInvalidate, apiYggdarsilSignout, apiFillGameProfile, apiJoinServer, apiHasJoinServer, apiProfilesLookup, skinWhitelist, yggdrasilPublickey, apiUsername2Profile);
    }

    @Override
    protected void setup() {
        this.addTransformUnit("com.mojang.authlib.yggdrasil.YggdrasilMinecraftSessionService", new YggdrasilPublicKeyTransformUnit("yggdrasil_publickey_transformer", this.yggdrasilPublickey));
        this.addTransformUnit("com.mojang.authlib.yggdrasil.YggdrasilMinecraftSessionService", new SkinWhitelistDomainTransformUnit("skin_whitelist_domain_transformer", this.skinWhitelist));
    }

    @Override
    public byte[] transform(ClassLoader loader, final String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        if (className != null) {
            try {
                byte[] bytecode = classfileBuffer;
                boolean modified = false;
                Collection classunits = (Collection)this.units.get(className);
                if (classunits != null) {
                    bytecode = this.transformClass(classunits, classfileBuffer);
                    modified = true;
                }
                if (this.canTransform(className)) {
                    ClassReader classreader = new ClassReader(bytecode);
                    ClassWriter classwriter = new ClassWriter(1);
                    final Transformer.TransformCheckCallbackImpl callback = new Transformer.TransformCheckCallbackImpl();
                    classreader.accept(new ClassVisitor(327680, classwriter){

                        @Override
                        public MethodVisitor visitMethod(int access, final String name, String desc, String signature, String[] exceptions) {
                            MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
                            return new MethodVisitor(327680, mv){

                                @Override
                                public void visitLdcInsn(Object cst) {
                                    String transformed;
                                    if (cst instanceof String && (transformed = ExhaustiveTransformer.this.transformString((String)cst)) != null) {
                                        super.visitLdcInsn(transformed);
                                        callback.allowTransform();
                                        ExhaustiveTransformer.this.logger.info("transform " + className + ":" + name + " " + cst + " -> " + transformed);
                                        return;
                                    }
                                    super.visitLdcInsn(cst);
                                }
                            };
                        }
                    }, 0);
                    if (callback.isAllowed || modified) {
                        byte[] output = classwriter.toByteArray();
                        if (this.debugMode) {
                            this.debugSaveModifiedClass(output, className);
                        }
                        return classwriter.toByteArray();
                    }
                }
            }
            catch (Throwable e) {
                this.logger.severe("failed to transform " + className);
                e.printStackTrace();
            }
        }
        return null;
    }

    private boolean canTransform(String classInternalName) {
        String name = classInternalName.replace('/', '.');
        for (String nonTransformablePackage : this.nonTransformablePackages) {
            if (!name.startsWith(nonTransformablePackage)) continue;
            return false;
        }
        return true;
    }

    private String transformString(String origin) {
        String str = origin;
        str = str.replaceAll("https://sessionserver.mojang.com/session/minecraft/profile/", this.apiFillGameProfile);
        str = str.replaceAll("https://sessionserver.mojang.com/session/minecraft/join", this.apiJoinServer);
        str = str.replaceAll("https://sessionserver.mojang.com/session/minecraft/hasJoined", this.apiHasJoinServer);
        str = str.replaceAll("https://api.mojang.com/profiles/", this.apiProfilesLookup);
        str = str.replaceAll("https://api.mojang.com/users/profiles/minecraft/", this.apiUsername2Profile);
        str = str.replaceAll("https://authserver.mojang.com/authenticate", this.apiYggdrasilAuthenticate);
        str = str.replaceAll("https://authserver.mojang.com/refresh", this.apiYggdrasilRefresh);
        str = str.replaceAll("https://authserver.mojang.com/validate", this.apiYggdrasilValidate);
        str = str.replaceAll("https://authserver.mojang.com/invalidate", this.apiYgggdrasilInvalidate);
        return origin.equals(str = str.replaceAll("https://authserver.mojang.com/signout", this.apiYggdarsilSignout)) ? null : str;
    }
}

