/*
 * Decompiled with CFR 0.152.
 */
package yushijinhun.authlibagent.javaagent;

import java.util.Objects;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import yushijinhun.authlibagent.javaagent.NamedTransformUnit;
import yushijinhun.authlibagent.javaagent.TransformUnit;

public class LdcTransformUnit
extends NamedTransformUnit {
    Object method;
    Object ldc;
    Object replacement;

    LdcTransformUnit(String name, Object method, Object ldc, Object replacement) {
        super(name);
        this.method = method;
        this.ldc = ldc;
        this.replacement = replacement;
    }

    @Override
    public ClassVisitor check(final TransformUnit.TransformCheckCallback callback) {
        if (this.replacement != null) {
            return new LdcClassVisitor(){

                @Override
                void checked(MethodVisitor mv) {
                    callback.allowTransform();
                }
            };
        }
        return null;
    }

    @Override
    public ClassVisitor transform(ClassWriter writer) {
        return new LdcClassVisitor((ClassVisitor)writer){

            @Override
            void checked(MethodVisitor mv) {
                mv.visitLdcInsn(LdcTransformUnit.this.replacement);
            }
        };
    }

    abstract class LdcClassVisitor
    extends ClassVisitor {
        LdcClassVisitor() {
            super(327680);
        }

        LdcClassVisitor(ClassVisitor cv) {
            super(327680, cv);
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
            if (LdcTransformUnit.this.method.equals(name)) {
                return new MethodVisitor(327680, mv){

                    @Override
                    public void visitLdcInsn(Object cst) {
                        if (Objects.equals(LdcTransformUnit.this.ldc, cst)) {
                            LdcClassVisitor.this.checked(this.mv);
                        } else {
                            super.visitLdcInsn(cst);
                        }
                    }
                };
            }
            return mv;
        }

        abstract void checked(MethodVisitor var1);
    }
}

