/*
 * Decompiled with CFR 0.152.
 */
package yushijinhun.authlibagent.javaagent;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.FileHandler;
import java.util.logging.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import yushijinhun.authlibagent.javaagent.TransformUnit;

public class Transformer
implements ClassFileTransformer {
    protected final Logger logger = Logger.getLogger(this.getClass().getCanonicalName());
    protected Map<String, Collection<TransformUnit>> units = new ConcurrentHashMap<String, Collection<TransformUnit>>();
    protected boolean debugMode;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addTransformUnit(String className, TransformUnit unit) {
        Objects.requireNonNull(className);
        Objects.requireNonNull(unit);
        className = className.replace('.', '/');
        Map<String, Collection<TransformUnit>> map = this.units;
        synchronized (map) {
            Collection<TransformUnit> classUnits = this.units.get(className);
            if (classUnits == null) {
                classUnits = new CopyOnWriteArrayList<TransformUnit>();
                this.units.put(className, classUnits);
            }
            classUnits.add(unit);
        }
    }

    public synchronized void debugOn() {
        if (this.debugMode) {
            return;
        }
        this.debugMode = true;
        try {
            this.logger.addHandler(new FileHandler("authlibagent.log"));
        }
        catch (IOException | SecurityException e) {
            this.logger.severe("failed to add file handler" + e);
            e.printStackTrace();
        }
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        if (className != null) {
            try {
                Collection<TransformUnit> classunits = this.units.get(className);
                if (classunits != null) {
                    this.logger.info("try to transform " + className);
                    byte[] output = this.transformClass(classunits, classfileBuffer);
                    if (output != null) {
                        this.logger.info("transform " + className);
                        if (this.debugMode) {
                            this.debugSaveModifiedClass(output, className);
                        }
                        return output;
                    }
                }
            }
            catch (Throwable e) {
                this.logger.severe("failed to transform " + className);
                e.printStackTrace();
            }
        }
        return null;
    }

    protected void debugSaveModifiedClass(byte[] classBuffer, String className) {
        className = className.replace('/', '.');
        try (FileOutputStream out = new FileOutputStream(className + "_modified.class");){
            ((OutputStream)out).write(classBuffer);
        }
        catch (IOException e) {
            this.logger.warning("failed to save modified class " + className + "\u3000: " + e);
            e.printStackTrace();
        }
    }

    protected byte[] transformClass(Collection<TransformUnit> classunits, byte[] classbuffer) {
        if (this.units == null) {
            return null;
        }
        boolean changed = false;
        byte[] currentClass = classbuffer;
        ClassReader classreader = new ClassReader(currentClass);
        for (TransformUnit unit : classunits) {
            TransformCheckCallbackImpl callback;
            ClassVisitor checker = unit.check(callback = new TransformCheckCallbackImpl());
            if (checker != null) {
                classreader.accept(checker, 2);
            }
            if (!callback.isAllowed) continue;
            this.logger.info("transform unit " + unit);
            ClassWriter classwriter = new ClassWriter(1);
            ClassVisitor modifier = unit.transform(classwriter);
            classreader.accept(modifier, 0);
            currentClass = classwriter.toByteArray();
            classreader = new ClassReader(currentClass);
            changed = true;
        }
        if (changed) {
            return currentClass;
        }
        return null;
    }

    protected static class TransformCheckCallbackImpl
    implements TransformUnit.TransformCheckCallback {
        boolean isAllowed = false;

        protected TransformCheckCallbackImpl() {
        }

        @Override
        public void allowTransform() {
            this.isAllowed = true;
        }
    }
}

