/*
 * Hello Minecraft! Launcher.
 * Copyright (C) 2013  huangyuhui <huanghongxun2008@126.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see {http://www.gnu.org/licenses/}.
 */
package org.jackhuang.hellominecraft.launcher.ui.modpack;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.DefaultTreeModel;
import org.jackhuang.hellominecraft.util.C;
import org.jackhuang.hellominecraft.util.Pair;
import org.jackhuang.hellominecraft.util.func.BiFunction;
import org.jackhuang.hellominecraft.util.system.FileUtils;
import org.jackhuang.hellominecraft.util.ui.checktree.CheckBoxTreeCellRenderer;
import org.jackhuang.hellominecraft.util.ui.checktree.CheckBoxTreeNode;
import org.jackhuang.hellominecraft.util.ui.checktree.CheckBoxTreeNodeSelectionListener;
import org.jackhuang.hellominecraft.util.ui.wizard.spi.WizardController;

/**
 *
 * @author huangyuhui
 */
public class ModpackFileSelectionPanel extends javax.swing.JPanel {

    private transient final WizardController controller;
    private final Map wizardData;
    private transient final BiFunction<String, Boolean, Integer> blackList;
    private final Set<String> bannedFiles = new HashSet<>();

    /**
     * Creates new form ModpackFileSelectionPanel
     *
     * @param blackList Return 0: non blocked, 1: non shown, 2: suggested,
     *                  checked
     */
    public ModpackFileSelectionPanel(WizardController controller, Map wizardData, File gameDir, BiFunction<String, Boolean, Integer> blackList) {
        initComponents();

        this.controller = controller;
        this.wizardData = wizardData;
        this.blackList = blackList;

        CheckBoxTreeNode root = create(gameDir, "minecraft");

        jTree1.setModel(new DefaultTreeModel(root));
        jTree1.setCellRenderer(new CheckBoxTreeCellRenderer());
        jTree1.addMouseListener(new CheckBoxTreeNodeSelectionListener());

        wizardData.put("blackList", root);
    }

    private static final HashMap<String, String> TRANSLATION = new HashMap<String, String>() {
        {
            put("minecraft/servers.dat", C.i18n("modpack.files.servers_dat"));
            put("minecraft/saves", C.i18n("modpack.files.saves"));
            put("minecraft/mods", C.i18n("modpack.files.mods"));
            put("minecraft/config", C.i18n("modpack.files.config"));
            put("minecraft/liteconfig", C.i18n("modpack.files.liteconfig"));
            put("minecraft/resourcepacks", C.i18n("modpack.files.resourcepacks"));
            put("minecraft/options.txt", C.i18n("modpack.files.options_txt"));
            put("minecraft/optionsshaders.txt", C.i18n("modpack.files.optionsshaders_txt"));
            put("minecraft/mods/VoxelMods", C.i18n("modpack.files.mods.voxelmods"));
            put("minecraft/dumps", C.i18n("modpack.files.dumps"));
            put("minecraft/blueprints", C.i18n("modpack.files.blueprints"));
            put("minecraft/scripts", C.i18n("modpack.files.scripts"));
        }
    };

    CheckBoxTreeNode create(File file, String basePath) {
        int state = 0;
        if (basePath.length() > "minecraft/".length())
            if ((state = blackList.apply(basePath.substring("minecraft/".length()) + (file.isDirectory() ? "/" : ""), file.isDirectory())) == 1)
                return null;
        CheckBoxTreeNode node = new CheckBoxTreeNode(TRANSLATION.containsKey(basePath) ? new Pair<>(FileUtils.getName(basePath), TRANSLATION.get(basePath)) : FileUtils.getName(basePath));
        if (state == 2)
            node.setSelected(true);

        if (file.isDirectory()) {
            File[] f = file.listFiles();
            for (File subFile : f) {
                CheckBoxTreeNode subNode = create(subFile, basePath + "/" + subFile.getName());
                if (subNode != null) {
                    subNode.setSelected(subNode.isSelected() | node.isSelected());
                    node.add(subNode);
                }
            }
            if (!node.children().hasMoreElements())
                return null;
        }

        return node;
    }

    /**
     * This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jScrollPane1 = new javax.swing.JScrollPane();
        jTree1 = new javax.swing.JTree();

        jScrollPane1.setViewportView(jTree1);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 400, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jScrollPane1, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 300, Short.MAX_VALUE)
        );
    }// </editor-fold>//GEN-END:initComponents

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTree jTree1;
    // End of variables declaration//GEN-END:variables
}
