package org.jackhuang.hellominecraft.launcher;

import com.google.gson.Gson;
import org.jackhuang.hellominecraft.launcher.util.Json.Attribute;
import org.jackhuang.hellominecraft.launcher.util.download.DownloadFiles;
import org.jackhuang.hellominecraft.launcher.util.unzip.ZipUtil;

import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;

public class uptade {
    private static String name;
    private static String version;
    private static boolean update;
    private static String url;

    private static boolean FCK = false;

    public uptade() {
        File dir = new File(".minecraft/version");
        try {
            if (new File(dir.getCanonicalPath()).createNewFile()) {
                System.out.println("创建目录 成功！");
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
        sendRequest();
    }

    private static void sendRequest() {
        // 开启线程来发起网络请求
        new Thread(new Runnable() {
            @Override
            public void run() {
                HttpURLConnection connection = null;
                try {
                    URL url = new URL(Main.http + "/minecraft/update/dataJson.json");
                    connection = (HttpURLConnection) url.openConnection();
                    connection.setRequestMethod("GET");
                    connection.setConnectTimeout(8000);
                    connection.setReadTimeout(8000);
                    InputStream in = connection.getInputStream();
                    // 下面对获取到的输入流进行读取
                    BufferedReader reader = new BufferedReader(new
                            InputStreamReader(in));
                    String response = new String();
                    String line;
                    while ((line = reader.readLine()) != null) {
                        response += line;
                    }
                    parseJSONWithJSONObject(response);

                } catch (Exception e) {
                    e.printStackTrace();
                } finally {
                    if (connection != null) {
                        connection.disconnect();
                    }
                }
            }
        }).start();
    }

    private static void parseJSONWithJSONObject(String jsonData) {
        //使用 Gson 解析json数据
        Gson gson = new Gson();
        Attribute appList = new Attribute();
        appList = gson.fromJson(jsonData, Attribute.class);

        name = appList.getName();
        version = appList.getVersion();
        update = appList.getUpdate();
        url = appList.getUrl();
        System.out.println("name: " + name);
        System.out.println("version: " + version);
        System.out.println("update: " + update);
        System.out.println("url: " + url);

        File file = new File(".minecraft/version");
        StringBuilder result = new StringBuilder();
        try{
            BufferedReader br = new BufferedReader(new FileReader(file));//构造一个BufferedReader类来读取文件
            String s = null;
            while((s = br.readLine())!=null){//使用readLine方法，一次读一行
                result.append(System.lineSeparator()+s);
            }
            br.close();
        }catch(Exception e){
            e.printStackTrace();
        }

        if (!update)return;
        if (!version.equals(result)){
            System.out.println("发现可更新程序 " + url + name);
            new DownloadFiles("发现更新",  url + "/" + name, "update");
        }else {
            System.out.println("没有发现可更新程序");
        }
    }

    public static void untadeUnZip(){
        try {
            ZipUtil.unZipFiles("update/" + name, "./");
            File file = new File(".minecraft/version");
            PrintStream ps = new PrintStream(new FileOutputStream(file));
            ps.println(version);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }


}
